﻿$tsenv = New-Object -COMObject Microsoft.SMS.TSEnvironment
$BA_FailedSteps = (New-Object -COMObject Microsoft.SMS.TSEnvironment).GetVariables() | Where-Object {$_ -Like "BA_FailedStepName*"}
$BA_FailedStepReturnCodes = (New-Object -COMObject Microsoft.SMS.TSEnvironment).GetVariables() | Where-Object {$_ -Like "BA_FailedStepReturnCode*"}
$RegistryPath = "HKLM:$($tsenv.Value('RegistryPath'))\$($tsenv.Value('SMSTS_Build'))"

$FailedSteps = @()
if ($BA_FailedSteps -ne $null)
    {
    Write-Output "Found Band-aid Failures"
    
    foreach ($BA_FailedStep in $BA_FailedSteps)
        {
        $ID = ($BA_FailedStep).Split("_") | Select-Object -Last 1
        $CorrispondingReturnCode = $BA_FailedStepReturnCodes | Where-Object {$_ -match $ID}
        $ReturnCode = $tsenv.Value($CorrispondingReturnCode)
        $StepName = $tsenv.Value($BA_FailedStep)
        $FailedSteps += @([pscustomobject]@{StepName=$StepName;ExitCode=$ReturnCode})
        }

    if ($FailedSteps -ne $null)
        {
        $Counter = 0
        foreach ($FailedStep in $FailedSteps)
            {
            $Counter ++
            $Number = "{0:D2}" -f $Counter
            Write-Output "Creating Registry Name FailedBandaid_$($Number)_Name with Value $($FailedStep.StepName)"
            New-ItemProperty -Path $RegistryPath -Name "FailedBandaid_$($Number)_Name" -Value $FailedStep.StepName -PropertyType String -Force -ErrorAction SilentlyContinue
            Write-Output "Creating Registry Name FailedBandaid_$($Number)_ExitCode with Value $($FailedStep.ExitCode)"
            New-ItemProperty -Path $RegistryPath -Name "FailedBandaid_$($Number)_ExitCode" -Value $FailedStep.ExitCode -PropertyType String -Force -ErrorAction SilentlyContinue
            }
        New-ItemProperty -Path $RegistryPath -Name "PreFlightReturnStatus" -Value "Failed Bandaids" -PropertyType String -Force -ErrorAction SilentlyContinue
        }
    
    }
else
    {
    Write-Output "No Band-aid Failures Recorded"
    }